"use client"

import { Button } from "@/components/ui/button";
import { useApplicationWorkflow } from "@/hooks/use-application-workflow";
import { cn } from "@/lib/utils";
import { TransformedAgency } from "@/types/transformers";
import { ComponentWithClassName } from "@/types/utils";
import { Download } from "lucide-react";

export function WorkflowButtonDownload({ data, className }: ComponentWithClassName<{ data: NonNullable<TransformedAgency> }>) {
  const { setWorkflow } = useApplicationWorkflow()
  if (data.access !== "ALL") {
    return;
  }

  return (
    <Button
      variant="outline"
      size={"sm"}
      onClick={() => setWorkflow({
        __tag: "DOWNLOAD_AGENCY_FEED",
        id: data.gtfsId,
      })}
      className={cn(
        className
      )}
      aria-label={`Open dialog to upload new feed files for ${data.name}.`}
    >
      <Download className="size-3" />
    </Button>
  )
}

